extends Node

onready var side_wall_touch : AudioStreamPlayer = $side_wall_touch
onready var side_explosive_touch : AudioStreamPlayer = $side_explosive_touch
onready var side_explosive_explosion : AudioStreamPlayer = $side_explosive_explosion
onready var game_over : AudioStreamPlayer = $game_over
onready var jump : AudioStreamPlayer = $jump
onready var landing : AudioStreamPlayer = $landing
onready var stair_explosion : AudioStreamPlayer = $stair_explosion
onready var power_up : AudioStreamPlayer = $power_up
onready var star : AudioStreamPlayer = $star
onready var checkpoint : AudioStreamPlayer = $checkpoint
onready var bg_music : AudioStreamPlayer = $bg_music


func _ready():
	if B4DFramework.get_settings().music:
		set_bg_music(true)

func side_wall_touch_play():
	if B4DFramework.get_settings().sound:
		side_wall_touch.play()

func side_explosive_touch_play():
	if B4DFramework.get_settings().sound:
		side_explosive_touch.play()

func side_explosive_explosion_play():
	if B4DFramework.get_settings().sound:
		side_explosive_explosion.play()

func game_over_play():
	if B4DFramework.get_settings().sound:
		game_over.play()

func jump_play():
	if B4DFramework.get_settings().sound:
		jump.play()

func landing_play():
	if B4DFramework.get_settings().sound:
		landing.play()

func stair_explosion_play():
	if B4DFramework.get_settings().sound:
		stair_explosion.play()

func power_up_play():
	if B4DFramework.get_settings().sound:
		power_up.play()


func checkpoint_play():
	if B4DFramework.get_settings().sound:
		checkpoint.play()


func star_play():
	if B4DFramework.get_settings().sound:
		star.play()


func set_bg_music(active : bool) -> void:
	if active:
		bg_music.play()
	else :
		bg_music.stop()

